﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class PatternGen : UserControl
    {

        PatternGenerator Gen;

        public PatternGen()
        {
            InitializeComponent();
            this.EnabledChanged += new EventHandler(PatternGenCtrl_EnabledChanged);

            cbo_Signal.Items.Clear();
            cbo_Pattern.Items.Clear();


            /*********************************************************************
             *  The following are examples of common telephony signals and cadences
             *  which are used often in call-progress tones
             * */

            cbo_Signal.Items.Add(new DualToneSignal("North American - Dial Tone",
                                                    Frequency.InHz(350),
                                                    Frequency.InHz(440),
                                                    SignalLevel.IndBV(-10)));


            cbo_Signal.Items.Add(new DualToneSignal("North American - Ring Back",
                                                    Frequency.InHz(440),
                                                    Frequency.InHz(480),
                                                    SignalLevel.IndBV(-10)));


            cbo_Signal.Items.Add(new DualToneSignal("North American - Busy Signal",
                                                    Frequency.InHz(480),
                                                    Frequency.InHz(620),
                                                    SignalLevel.IndBV(-10)));

            cbo_Signal.Items.Add(new MultiToneSignal("North American - Receiver Off Hook",SignalLevel.IndBV(-10),
                                                    Frequency.InHz(1400),
                                                    Frequency.InHz(2060),
                                                    Frequency.InHz(2450),
                                                    Frequency.InHz(2600)));

            // This is the most common dial tone signal in europe
            cbo_Signal.Items.Add(new MultiToneSignal("Italian - Dial Tone", SignalLevel.IndBV(-10),
                                                    Frequency.InHz(425)));



            // This demonstrates how to generate AM modulated ring-back signals ( 400 Hz modulated at 25 Hz)
            cbo_Signal.Items.Add(new AMTone("Irish - Ring Back (AM) ", 
                                            SignalLevel.IndBV(-10),
                                            Frequency.InHz(400),
                                            50,                         // Modulation depth %
                                            Frequency.InHz(25)));


            // This is the most common dial tone signal in europe
            cbo_Signal.Items.Add(new MultiToneSignal("Germain - Ring Back", SignalLevel.IndBV(-10),
                                                    Frequency.InHz(450)));


           

            cbo_Pattern.Items.Add("No Pattern");

            // Stutter dial tone is 10 cycles of 100ms on 100ms off then signal is left on
            cbo_Pattern.Items.Add( new RepeatingCadence("North American - Stutter Dial",10,true,  
                                                                TimeInterval.InMilliseconds(100),
                                                                TimeInterval.InMilliseconds(100)));

            // North American ring-back = 2 seconds on / 4 seconds off
            cbo_Pattern.Items.Add(new RepeatingCadence("North American - Ringback", 
                                                        TimeInterval.InSeconds(2),
                                                       TimeInterval.InSeconds(4)));

            // North American busy signal = 500 ms on / 500 ms off
            cbo_Pattern.Items.Add(new RepeatingCadence("North American - Busy ", 
                                                        TimeInterval.InMilliseconds(500),
                                                        TimeInterval.InMilliseconds(500)));

            // North American busy signal = 500 ms on / 500 ms off
            cbo_Pattern.Items.Add(new RepeatingCadence("North American - Receiver Off Hook",
                                                        TimeInterval.InMilliseconds(100),
                                                       TimeInterval.InMilliseconds(100)));

            // Irish Ring-back uis 400ms on 200ms off 400ms on 2 seconds off
            cbo_Pattern.Items.Add(new RepeatingCadence("Irish - Ring Back", 
                                                        TimeInterval.InMilliseconds(400),
                                                        TimeInterval.InMilliseconds(200),
                                                        TimeInterval.InMilliseconds(400), 
                                                        TimeInterval.InSeconds(2)));


            cbo_Pattern.Items.Add(new RepeatingCadence("German - Ring Back", 
                                                        TimeInterval.InMilliseconds(250),
                                                        TimeInterval.InSeconds(4),
                                                        TimeInterval.InSeconds(1),
                                                        TimeInterval.InSeconds(4)));


            cbo_Pattern.SelectedIndex = 1;
            cbo_Signal.SelectedIndex = 0;



        }

        void PatternGenCtrl_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = this.Enabled;
        }

        public void SetGenerator(PatternGenerator Gen)
        {
            this.Gen = Gen;

        }

        private void btn_Stop_Click(object sender, EventArgs e)
        {
            try
            {
                Gen.StopGenerator();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void timer_Update_Tick(object sender, EventArgs e)
        {
            try
            {
                if (Gen ==null) return;
                string Status = "Pattern Generator ";

                if (Gen.IsActive) Status += "(Active)";

                gp_PatternGen.Text = Status;
            }
            catch { }
        }

        private void btn_Generate_Click(object sender, EventArgs e)
        {
            try
            {
                Gen.Generate((ISignal)cbo_Signal.SelectedItem, cbo_Pattern.SelectedItem as ISignalPattern);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

    }
}
